//****** CN121 SDK ******//
//*** SDK Information ***//
// Clock frequency: 80MHz
// Minimum clock frequency : 32MHz
// ADC sampling rate: 250Hz
// ADC resolution：12bit
// Power line frequency filter: 50Hz
// Optional medical standard ECG waveform
//Website: http://www.cyzur.com
//Mail: contactus@cyzur.com	
//Release Date: 2023/8/4
//Version: VB.1
//Copyright(C) CyzurTech (Shanghai) Co. Ltd. 2020-
//All rights reserved

#ifndef __USER_SYS_UTILS_H_
#define __USER_SYS_UTILS_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "stm32l4xx_hal.h"
#include <stdint.h>
#include <string.h>

/* Define Daughter Board(DB) 50Hz_Filter Switch */
#define FILTER_50HZ_ENABLE   0x01
#define FILTER_50HZ_DISABLE  0x00
/* Define Daughter Board(DB) LOD pin */
#define DB_LOD1_Pin GPIO_PIN_2
#define DB_LOD1_GPIO_Port GPIOA
/* Define Daughter Board(DB) RST pin */
#define DB_RST_Pin GPIO_PIN_5
#define DB_RST_GPIO_Port GPIOC
/* Define Daughter Board(DB) SPI pins */
#define DB_CSB_Pin GPIO_PIN_4
#define DB_CSB_GPIO_Port GPIOA
#define DB_SCLK_Pin GPIO_PIN_5
#define DB_SCLK_GPIO_Port GPIOA
#define DB_MOSI_Pin GPIO_PIN_7
#define DB_MOSI_GPIO_Port GPIOA
#define DB_MISO_Pin GPIO_PIN_6
#define DB_MISO_GPIO_Port GPIOA

/* Wrapper: WritePin Function */
void DB_RST_SET(void);
void DB_RST_RESET(void);
void DB_CSB_SET(void);
void DB_CSB_RESET(void);
void DB_SCLK_SET(void);
void DB_SCLK_RESET(void);
void DB_MOSI_SET(void);
void DB_MOSI_RESET(void);

/* Wrapper: ReadPin Function */
uint8_t DB_MISO_HIGH(void);
uint8_t DB_MISO_LOW(void);
uint8_t DB_LOD1_LOW(void);
uint8_t DB_LOD1_HIGH(void);

/*Wrapper: Microsecond delay: us */
void CN1xx_delay_us(uint32_t nus);

/*Wrapper: SPI */
uint8_t CN1xx_SPI_ReadWrite(uint8_t* TxDataSeq,uint8_t* RxDataSeq,uint8_t SeqLen);




/***********************Start define: Peripherals associated with CN121*************************************/
extern TIM_HandleTypeDef htim2;
extern ADC_HandleTypeDef hadc1;

/* systemClock config*/
void SystemClock_Config(void);
/*TIMER Init*/
void TIM2_Init(void);
/*ADC Init*/
void ADC1_Init(void);

/*GPIO Init*/
void GPIO_LOD_Init(void);
void GPIO_RST_Init(void);
void GPIO_SPI_Init(void);

/***********************End define: Peripherals associated with CN121 *************************************/


void Error_Handler(void);

#ifdef __cplusplus
}
#endif


#endif /* USER_SYS_UTILS_H_ */
